<?php
session_start();
include 'koneksi.php';

// Cek Login & ID
if (!isset($_SESSION['admin']) || !isset($_GET['id'])) {
    die("Akses ditolak.");
}

$id = $_GET['id'];

// Ambil Data Transaksi + Data Siswa
$q = mysqli_query($koneksi, "SELECT spp.*, siswa.nama, siswa.nis, siswa.kelas 
                             FROM spp 
                             JOIN siswa ON spp.id_siswa = siswa.id 
                             WHERE spp.id = '$id'");
$d = mysqli_fetch_array($q);

// Kalau data tidak ketemu
if (!$d) { die("Data tidak ditemukan."); }

// Format Tanggal Indonesia
$tgl_bayar = $d['tgl_bayar'] ? date('d-m-Y', strtotime($d['tgl_bayar'])) : date('d-m-Y');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kuitansi SPP - <?= $d['nama'] ?></title>
    <style>
        body { font-family: 'Courier New', Courier, monospace; padding: 40px; }
        .kuitansi { 
            border: 2px solid #000; 
            padding: 20px; 
            width: 700px; 
            margin: auto; 
        }
        .header { 
            text-align: center; 
            border-bottom: 2px double #000; 
            padding-bottom: 10px; 
            margin-bottom: 20px; 
        }
        .logo { font-size: 24px; font-weight: bold; }
        .alamat { font-size: 12px; }
        .row { display: flex; margin-bottom: 10px; }
        .label { width: 150px; font-weight: bold; }
        .isi { flex: 1; border-bottom: 1px dotted #000; }
        .footer { 
            margin-top: 30px; 
            text-align: right; 
            padding-right: 50px; 
        }
        .ttd { height: 60px; }
        
        /* Tombol Print (Hilang saat diprint) */
        .btn-print {
            display: block;
            margin: 20px auto;
            padding: 10px 20px;
            background: #0d6efd;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        @media print {
            .btn-print { display: none; }
        }
    </style>
</head>
<body>

    <button onclick="window.print()" class="btn-print">🖨️ Cetak Kuitansi</button>

    <div class="kuitansi">
        <div class="header">
            <div class="logo">SMA 1 CONTOH</div>
            <div class="alamat">Jl. Pendidikan No. 123, Kota Belajar, Indonesia</div>
            <h3>BUKTI PEMBAYARAN SPP</h3>
        </div>

        <div class="body">
            <div class="row">
                <div class="label">No. Transaksi</div>
                <div class="isi">: #TRX-<?= $d['id'] ?></div>
            </div>
            <div class="row">
                <div class="label">Telah Terima Dari</div>
                <div class="isi">: <b><?= $d['nama'] ?></b> (<?= $d['nis'] ?>)</div>
            </div>
            <div class="row">
                <div class="label">Kelas</div>
                <div class="isi">: <?= $d['kelas'] ?></div>
            </div>
            <div class="row">
                <div class="label">Guna Membayar</div>
                <div class="isi">: SPP Bulan <b><?= $d['bulan'] ?></b></div>
            </div>
            <div class="row">
                <div class="label">Terbilang Rp</div>
                <div class="isi" style="font-size: 18px; font-weight: bold;">
                    : Rp <?= number_format($d['jumlah'], 0, ',', '.') ?>,-
                </div>
            </div>
        </div>

        <div class="footer">
            <div>Kota Belajar, <?= $tgl_bayar ?></div>
            <div>Bendahara Sekolah,</div>
            <div class="ttd"></div>
            <div><b>( _______________________ )</b></div>
        </div>
    </div>

    <!-- Script otomatis print saat dibuka -->
    <script>
        window.onload = function() { window.print(); }
    </script>

</body>
</html>